********************************************************************************
**************************** Study population **********************************
******************************* Chapter 5 **************************************


*     Setting up globals so that it is easier to reference in code, replace with your file path
global working "My file path:\...\CPRD data\Stata files\Working\"






******************************* Patient file  **********************************

	

*     We want to create a stata useable Patient stata file 


***************** Step 1: Import the Patient .txt file *************************
*     This is found in the Patient folder, replace the file path with your file path

import delimited "My file path:\....\Patient_001.txt", stringcols(1)

browse




***************** Step 2: Dropping unnaceptable records ************************
*     We want to drop those that are not coded 1 for acceptability and not coded 1 or 2 for gender

*     Gender:
drop if gender!=1 & gender!=2

*     Erroneous records:
drop if acceptable!=1




***************** Step 3: Formatting the dates in Patient file *****************
*     The loop below creates these dates into stata readable dates and replaces the variable name back to the original
foreach date in emis_ddate regstartdate regenddate cprd_ddate {
gen `date'1 = date(`date', "DMY")
format `date'1 %td
drop `date'
rename `date'1 `date'
}

sort patid





***************** Step 4: Save in Working folder *******************************
save "My file path:\...\Stata files\Working\patient.dta"
















******************************* Practice file  *********************************



*     We want to create a stata useable Practice stata file 


***************** Step 1: Import the Practice .txt file ************************
*     This is found in the Practice folder, replace the file path with your file path
import delimited "My file path:\...\Practice_001.txt", clear




***************** Step 2: Format dates *****************************************

gen lcd1 = date(lcd, "DMY")
format lcd1 %td
drop lcd
rename lcd1 lcd

drop uts




***************** Step 3: Save in Working folder *******************************
save "My file path:\...\Stata files\Working\practice.dta"







************************** Patient & Practice **********************************
***************** Step 1: Merge patient and practice stata files ***************
*merging
merge m:1 pracid using "$working\practice.dta"

**hopefully they are all matched but if not
drop if _merge == 2
drop _merge




